/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuPeer;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class Menu
extends MenuItem {
    final List<Entry> menuEntries = new ArrayList<Entry>();

    public Menu() {
    }

    public Menu(String text) {
        super(text);
    }

    public Menu(String text, ActionListener callback) {
        super(text, callback);
    }

    public Menu(String text, String imagePath) {
        super(text, imagePath);
    }

    public Menu(String text, File imageFile) {
        super(text, imageFile);
    }

    public Menu(String text, URL imageUrl) {
        super(text, imageUrl);
    }

    public Menu(String text, InputStream imageStream) {
        super(text, imageStream);
    }

    public Menu(String text, Image image) {
        super(text, image);
    }

    public Menu(String text, String imagePath, ActionListener callback) {
        super(text, imagePath, callback);
    }

    public Menu(String text, File imageFile, ActionListener callback) {
        super(text, imageFile, callback);
    }

    public Menu(String text, URL imageUrl, ActionListener callback) {
        super(text, imageUrl, callback);
    }

    public Menu(String text, InputStream imageStream, ActionListener callback) {
        super(text, imageStream, callback);
    }

    public Menu(String text, Image image, ActionListener callback) {
        super(text, image, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(MenuPeer peer, Menu parent, SystemTray systemTray) {
        ArrayList<Entry> copy;
        super.bind(peer, parent, systemTray);
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            copy = new ArrayList<Entry>(this.menuEntries);
        }
        int menuEntriesSize = copy.size();
        for (int i = 0; i < menuEntriesSize; ++i) {
            Entry menuEntry = (Entry)copy.get(i);
            peer.add(this, menuEntry, i);
        }
    }

    public final <T extends Entry> T add(T entry) {
        return this.add(entry, -1);
    }

    public final Menu add(JMenu entry) {
        Menu menu = new Menu();
        menu.setEnabled(entry.isEnabled());
        Icon icon = entry.getIcon();
        BufferedImage bimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        menu.setImage(bimage);
        menu.setText(entry.getText());
        menu.setShortcut(entry.getMnemonic());
        for (Component c : entry.getMenuComponents()) {
            if (c instanceof JMenu) {
                menu.add((JMenu)c);
                continue;
            }
            if (c instanceof JCheckBoxMenuItem) {
                menu.add((JCheckBoxMenuItem)c);
                continue;
            }
            if (c instanceof JMenuItem) {
                menu.add((JMenuItem)c);
                continue;
            }
            if (!(c instanceof JSeparator)) continue;
            menu.add((JSeparator)c);
        }
        this.add(menu);
        return this;
    }

    public final Menu add(JCheckBoxMenuItem entry) {
        Checkbox checkbox = new Checkbox();
        final ActionListener[] actionListeners = entry.getActionListeners();
        if (actionListeners != null) {
            if (actionListeners.length == 1) {
                checkbox.setCallback(actionListeners[0]);
            } else {
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (ActionListener actionListener : actionListeners) {
                            actionListener.actionPerformed(e);
                        }
                    }
                };
                checkbox.setCallback(actionListener);
            }
        }
        checkbox.setEnabled(entry.isEnabled());
        checkbox.setChecked(entry.getState());
        checkbox.setShortcut(entry.getMnemonic());
        checkbox.setText(entry.getText());
        this.add(checkbox);
        return this;
    }

    public final Menu add(JMenuItem entry) {
        MenuItem item = new MenuItem();
        final ActionListener[] actionListeners = entry.getActionListeners();
        if (actionListeners != null) {
            if (actionListeners.length == 1) {
                item.setCallback(actionListeners[0]);
            } else {
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (ActionListener actionListener : actionListeners) {
                            actionListener.actionPerformed(e);
                        }
                    }
                };
                item.setCallback(actionListener);
            }
        }
        item.setEnabled(entry.isEnabled());
        Icon icon = entry.getIcon();
        BufferedImage bimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        item.setImage(bimage);
        item.setShortcut(entry.getMnemonic());
        item.setText(entry.getText());
        this.add(item);
        return this;
    }

    public final Menu add(JSeparator entry) {
        Separator separator = new Separator();
        this.add(separator);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entry> T add(T entry, int index) {
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            if (index == -1) {
                this.menuEntries.add(entry);
            } else {
                if (!this.menuEntries.isEmpty() && this.menuEntries.get(0) instanceof Status) {
                    ++index;
                }
                this.menuEntries.add(index, entry);
            }
        }
        if (this.peer != null) {
            ((MenuPeer)this.peer).add(this, entry, index);
        }
        return entry;
    }

    public final Entry getFirst() {
        return this.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getLast() {
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            if (!this.menuEntries.isEmpty()) {
                for (int i = this.menuEntries.size() - 1; i >= 0; --i) {
                    Entry entry = this.menuEntries.get(i);
                    if (entry instanceof Separator || entry instanceof Status) continue;
                    return entry;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get(int menuIndex) {
        if (menuIndex < 0) {
            return null;
        }
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            if (!this.menuEntries.isEmpty()) {
                int count = 0;
                for (Entry entry : this.menuEntries) {
                    if (entry instanceof Separator || entry instanceof Status) continue;
                    if (count == menuIndex) {
                        return entry;
                    }
                    ++count;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Entry entry) {
        if (entry != null) {
            Entry toRemove = null;
            List<Entry> list = this.menuEntries;
            synchronized (list) {
                Iterator<Entry> iterator = this.menuEntries.iterator();
                while (iterator.hasNext()) {
                    Entry entry__ = iterator.next();
                    if (entry__ != entry) continue;
                    iterator.remove();
                    toRemove = entry__;
                    break;
                }
            }
            if (toRemove != null) {
                toRemove.remove();
                toRemove = null;
            }
            list = this.menuEntries;
            synchronized (list) {
                if (!this.menuEntries.isEmpty() && this.menuEntries.get(0) instanceof Separator) {
                    toRemove = this.menuEntries.get(0);
                }
            }
            if (toRemove != null) {
                this.remove(toRemove);
                toRemove = null;
            }
            list = this.menuEntries;
            synchronized (list) {
                if (!this.menuEntries.isEmpty() && this.menuEntries.get(this.menuEntries.size() - 1) instanceof Separator) {
                    toRemove = this.menuEntries.get(this.menuEntries.size() - 1);
                }
            }
            if (toRemove != null) {
                this.remove(toRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<Entry> copy;
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            copy = new ArrayList<Entry>(this.menuEntries);
            this.menuEntries.clear();
        }
        for (Entry entry : copy) {
            entry.remove();
        }
    }

    @Override
    public void remove() {
        this.clear();
        super.remove();
    }
}

