/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.nativeUI;

import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.nativeUI.AwtMenu;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.util.SwingUtil;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class AwtMenuItem
implements MenuItemPeer {
    private final AwtMenu parent;
    private final java.awt.MenuItem _native = new java.awt.MenuItem();
    private volatile ActionListener swingCallback;

    AwtMenuItem(AwtMenu parent) {
        this.parent = parent;
        parent._native.add(this._native);
    }

    @Override
    public void setImage(MenuItem menuItem) {
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItem.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItem.this._native.setLabel(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        if (this.swingCallback != null) {
            this._native.removeActionListener(this.swingCallback);
        }
        if (menuItem.getCallback() != null) {
            this.swingCallback = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionListener cb = menuItem.getCallback();
                    if (cb != null) {
                        try {
                            cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    }
                }
            };
            this._native.addActionListener(this.swingCallback);
        } else {
            this.swingCallback = null;
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char shortcut = menuItem.getShortcut();
        final int vKey = SwingUtil.getVirtualKey(shortcut);
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItem.this._native.setShortcut(new MenuShortcut(vKey));
            }
        });
    }

    @Override
    public void remove() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenuItem.this._native.deleteShortcut();
                AwtMenuItem.this._native.setEnabled(false);
                if (AwtMenuItem.this.swingCallback != null) {
                    AwtMenuItem.this._native.removeActionListener(AwtMenuItem.this.swingCallback);
                    AwtMenuItem.this.swingCallback = null;
                }
                ((AwtMenuItem)AwtMenuItem.this).parent._native.remove(AwtMenuItem.this._native);
                AwtMenuItem.this._native.removeNotify();
            }
        });
    }
}

