/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.swingUI;

import com.sun.jna.Pointer;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.jna.linux.GEventCallback;
import dorkbox.systemTray.jna.linux.GdkEventButton;
import dorkbox.systemTray.jna.linux.Gobject;
import dorkbox.systemTray.jna.linux.Gtk;
import dorkbox.systemTray.swingUI.SwingMenu;
import dorkbox.systemTray.swingUI.SwingUI;
import dorkbox.systemTray.swingUI.TrayPopup;
import dorkbox.util.SwingUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPopupMenu;

public class _GtkStatusIconTray
extends Tray
implements SwingUI {
    private volatile Pointer trayIcon;
    private GEventCallback gtkCallback = null;
    private AtomicBoolean shuttingDown = new AtomicBoolean();
    private volatile boolean isActive = false;
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile Runnable popupRunnable;

    public _GtkStatusIconTray(final SystemTray systemTray) {
        Gtk.startGui();
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                _GtkStatusIconTray.this.trayIcon = Gtk.gtk_status_icon_new();
                _GtkStatusIconTray.this.gtkCallback = new GEventCallback(){

                    @Override
                    public void callback(Pointer notUsed, GdkEventButton event) {
                        if (event.type == 4) {
                            SwingUtil.invokeLater(_GtkStatusIconTray.this.popupRunnable);
                        }
                    }
                };
                Gobject.g_signal_connect_object(_GtkStatusIconTray.this.trayIcon, "button_press_event", _GtkStatusIconTray.this.gtkCallback, null, 0);
            }
        });
        Gtk.waitForStartup();
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.gtk_status_icon_set_title(_GtkStatusIconTray.this.trayIcon, "SystemTray");
                if (System.getProperty("SystemTray_SET_NAME", "false").equals("true")) {
                    Gtk.gtk_status_icon_set_name(_GtkStatusIconTray.this.trayIcon, "SystemTray");
                }
            }
        });
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                final SwingMenu swingMenu = new SwingMenu(null){

                    @Override
                    public void setEnabled(final MenuItem menuItem) {
                        Gtk.dispatch(new Runnable(){

                            @Override
                            public void run() {
                                boolean enabled = menuItem.getEnabled();
                                if (_GtkStatusIconTray.this.visible && !enabled) {
                                    Gtk.gtk_status_icon_set_visible(_GtkStatusIconTray.this.trayIcon, enabled);
                                    _GtkStatusIconTray.this.visible = false;
                                } else if (!_GtkStatusIconTray.this.visible && enabled) {
                                    Gtk.gtk_status_icon_set_visible(_GtkStatusIconTray.this.trayIcon, enabled);
                                    _GtkStatusIconTray.this.visible = true;
                                }
                            }
                        });
                    }

                    @Override
                    public void setImage(MenuItem menuItem) {
                        _GtkStatusIconTray.this.imageFile = menuItem.getImage();
                        if (_GtkStatusIconTray.this.imageFile == null) {
                            return;
                        }
                        Gtk.dispatch(new Runnable(){

                            @Override
                            public void run() {
                                Gtk.gtk_status_icon_set_from_file(_GtkStatusIconTray.this.trayIcon, _GtkStatusIconTray.this.imageFile.getAbsolutePath());
                                if (!_GtkStatusIconTray.this.isActive) {
                                    _GtkStatusIconTray.this.isActive = true;
                                    Gtk.gtk_status_icon_set_visible(_GtkStatusIconTray.this.trayIcon, true);
                                }
                            }
                        });
                        SwingUtil.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((TrayPopup)_native).setTitleBarImage(_GtkStatusIconTray.this.imageFile);
                            }
                        });
                    }

                    @Override
                    public void setText(MenuItem menuItem) {
                    }

                    @Override
                    public void setShortcut(MenuItem menuItem) {
                    }

                    @Override
                    public void remove() {
                        if (!_GtkStatusIconTray.this.shuttingDown.getAndSet(true)) {
                            Gtk.dispatch(new Runnable(){

                                @Override
                                public void run() {
                                    Gtk.gtk_status_icon_set_visible(_GtkStatusIconTray.this.trayIcon, false);
                                    Gobject.g_object_unref(_GtkStatusIconTray.this.trayIcon);
                                    _GtkStatusIconTray.this.trayIcon = null;
                                }
                            });
                            Gtk.shutdownGui();
                            super.remove();
                        }
                    }
                };
                JPopupMenu popupMenu = (JPopupMenu)swingMenu._native;
                popupMenu.pack();
                popupMenu.setFocusable(true);
                _GtkStatusIconTray.this.popupRunnable = new Runnable(){

                    @Override
                    public void run() {
                        Point point = MouseInfo.getPointerInfo().getLocation();
                        TrayPopup popupMenu = (TrayPopup)swingMenu._native;
                        popupMenu.doShow(point, 0);
                    }
                };
                _GtkStatusIconTray.this.bind(swingMenu, null, systemTray);
            }
        });
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

