/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.ImageUtils;
import dorkbox.util.BootStrapClassLoader;
import dorkbox.util.OS;
import java.awt.AWTException;
import java.awt.Robot;
import java.lang.reflect.Method;
import java.util.Locale;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;

public class SystemTrayFixes {
    public static void fixWindows() {
        boolean isWindowsSwingTrayLoaded;
        block7: {
            String vendor = System.getProperty("java.vendor").toLowerCase(Locale.US);
            if (!vendor.contains("sun ") && !vendor.contains("oracle ")) {
                return;
            }
            isWindowsSwingTrayLoaded = false;
            try {
                Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                m.setAccessible(true);
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                isWindowsSwingTrayLoaded = null != m.invoke((Object)cl, "sun.awt.windows.WTrayIconPeer") || null != m.invoke((Object)cl, "java.awt.SystemTray");
            }
            catch (Throwable e) {
                if (!SystemTray.DEBUG) break block7;
                SystemTray.logger.debug("Error detecting if the Swing SystemTray is loaded", e);
            }
        }
        if (isWindowsSwingTrayLoaded) {
            throw new RuntimeException("Unable to initialize the swing tray in windows, it has already been created!");
        }
        try {
            Robot robot = new Robot();
            ClassPool pool = ClassPool.getDefault();
            CtClass trayClass = pool.get("sun.awt.windows.WSystemTrayPeer");
            trayClass.setModifiers(trayClass.getModifiers() & 1);
            trayClass.getConstructors()[0].setModifiers(trayClass.getConstructors()[0].getModifiers() & 1);
            CtMethod ctMethodGet = trayClass.getDeclaredMethod("getTrayIconSize");
            ctMethodGet.setBody("{return new java.awt.Dimension(" + ImageUtils.TRAY_SIZE + ", " + ImageUtils.TRAY_SIZE + ");" + "}");
            byte[] trayBytes = trayClass.toBytecode();
            CtClass trayIconClass = pool.get("sun.awt.windows.WTrayIconPeer");
            CtMethod ctMethodCreate = trayIconClass.getDeclaredMethod("createNativeImage");
            CtMethod ctMethodUpdate = trayIconClass.getDeclaredMethod("updateNativeImage");
            int TRAY_MASK = ImageUtils.TRAY_SIZE * ImageUtils.TRAY_SIZE / 8;
            ctMethodCreate.setBody("{java.awt.image.BufferedImage bufferedImage = $1;java.awt.image.Raster rasterImage = bufferedImage.getRaster();final byte[] mask = new byte[" + TRAY_MASK + "];" + "final int pixels[] = ((java.awt.image.DataBufferInt)rasterImage.getDataBuffer()).getData();" + "int numberOfPixels = pixels.length;" + "int rasterImageWidth = rasterImage.getWidth();" + "for (int i = 0; i < numberOfPixels; i++) {" + "    int iByte = i / 8;" + "    int augmentMask = 1 << (7 - (i % 8));" + "    if ((pixels[i] & 0xFF000000) == 0) {" + "        if (iByte < mask.length) {" + "            mask[iByte] |= augmentMask;" + "        }" + "    }" + "}" + "if (rasterImage instanceof sun.awt.image.IntegerComponentRaster) {" + "    rasterImageWidth = ((sun.awt.image.IntegerComponentRaster)rasterImage).getScanlineStride();" + "}" + "setNativeIcon(((java.awt.image.DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), " + "mask, rasterImageWidth, rasterImage.getWidth(), rasterImage.getHeight());" + "}");
            ctMethodUpdate.setBody("{java.awt.Image image = $1;if (isDisposed()) {   return;}int imageWidth = image.getWidth(observer);int imageHeight = image.getWidth(observer);java.awt.image.BufferedImage trayIcon = new java.awt.image.BufferedImage(imageWidth, imageHeight, java.awt.image.BufferedImage.TYPE_INT_ARGB);java.awt.Graphics2D g = trayIcon.createGraphics();if (g != null) {   try {      g.addRenderingHints(new java.awt.RenderingHints(java.awt.RenderingHints.KEY_RENDERING,java.awt.RenderingHints.VALUE_RENDER_QUALITY));      g.drawImage(image, 0, 0, imageWidth, imageHeight, observer);      createNativeImage(trayIcon);      updateNativeIcon(!firstUpdate);      if (firstUpdate) {          firstUpdate = false;      }   } finally {      g.dispose();   }}}");
            byte[] trayIconBytes = trayIconClass.toBytecode();
            BootStrapClassLoader.defineClass(trayBytes);
            BootStrapClassLoader.defineClass(trayIconBytes);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Successfully changed tray icon size to: {}", (Object)ImageUtils.TRAY_SIZE);
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error setting tray icon size to: {}", (Object)ImageUtils.TRAY_SIZE, (Object)e);
        }
    }

    public static void fixMacOS() {
        boolean isMacTrayLoaded;
        block9: {
            String vendor = System.getProperty("java.vendor").toLowerCase(Locale.US);
            if (!vendor.contains("sun ") && !vendor.contains("oracle ")) {
                return;
            }
            isMacTrayLoaded = false;
            try {
                Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                m.setAccessible(true);
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                isMacTrayLoaded = null != m.invoke((Object)cl, "sun.lwawt.macosx.CTrayIcon") || null != m.invoke((Object)cl, "java.awt.SystemTray");
            }
            catch (Throwable e) {
                if (!SystemTray.DEBUG) break block9;
                SystemTray.logger.debug("Error detecting if the MacOS SystemTray is loaded", e);
            }
        }
        if (isMacTrayLoaded) {
            throw new RuntimeException("Unable to initialize the AWT tray in MacOSx, it has already been created!");
        }
        try {
            Robot robot = new Robot();
            robot.mousePress(1024);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        ClassPool pool = ClassPool.getDefault();
        int mouseDelay = 75;
        try {
            CtClass trayClass = pool.get("sun.lwawt.macosx.CTrayIcon");
            trayClass.setModifiers(trayClass.getModifiers() & 1);
            trayClass.getConstructors()[0].setModifiers(trayClass.getConstructors()[0].getModifiers() & 1);
            CtField ctField = new CtField(CtClass.intType, "lastButton", trayClass);
            trayClass.addField(ctField);
            ctField = new CtField(CtClass.intType, "lastX", trayClass);
            trayClass.addField(ctField);
            ctField = new CtField(CtClass.intType, "lastY", trayClass);
            trayClass.addField(ctField);
            ctField = new CtField(pool.get("java.awt.Robot"), "robot", trayClass);
            trayClass.addField(ctField);
            CtMethod ctMethodGet = trayClass.getDeclaredMethod("handleMouseEvent");
            String nsEventFQND = OS.javaVersion <= 7 ? "sun.lwawt.macosx.event.NSEvent" : "sun.lwawt.macosx.NSEvent";
            ctMethodGet.setBody("{" + nsEventFQND + " event = $1;" + "sun.awt.SunToolkit toolKit = (sun.awt.SunToolkit)java.awt.Toolkit.getDefaultToolkit();" + "int button = event.getButtonNumber();" + "int mouseX = event.getAbsX();" + "int mouseY = event.getAbsY();" + "if (lastButton == 1 && mouseX == lastX && mouseY == lastY) {" + "button = 1;" + "lastButton = -1;" + "lastX = 0;" + "lastY = 0;" + "}" + "if ((button <= 2 || toolKit.areExtraMouseButtonsEnabled()) && button <= toolKit.getNumberOfButtons() - 1) {" + "int eventType = " + nsEventFQND + ".nsToJavaEventType(event.getType());" + "int jButton = 0;" + "int jClickCount = 0;" + "if (eventType != 503) {" + "jButton = " + nsEventFQND + ".nsToJavaButton(button);" + "jClickCount = event.getClickCount();" + "}" + "int mouseMods = " + nsEventFQND + ".nsToJavaMouseModifiers(button, event.getModifierFlags());" + "boolean popupTrigger = " + nsEventFQND + ".isPopupTrigger(mouseMods);" + "int mouseMask = jButton > 0 ? java.awt.event.MouseEvent.getMaskForButton(jButton) : 0;" + "long event0 = System.currentTimeMillis();" + "if(eventType == 501) {" + "mouseClickButtons |= mouseMask;" + "} else if(eventType == 506) {" + "mouseClickButtons = 0;" + "}" + "if (eventType == 501 && popupTrigger && button == 1) {" + "if (robot == null) {" + "try {" + "robot = new java.awt.Robot();" + "robot.setAutoDelay(40);" + "robot.setAutoWaitForIdle(true);" + "} catch (java.awt.AWTException e) {" + "e.printStackTrace();" + "}" + "}" + "lastButton = 1;" + "lastX = mouseX;" + "lastY = mouseY;" + "int maskButton1 = java.awt.event.InputEvent.getMaskForButton(java.awt.event.MouseEvent.BUTTON1);" + "robot.mousePress(maskButton1);" + "robot.delay(" + mouseDelay + ");" + "return;" + "}" + "java.awt.event.MouseEvent mEvent = new java.awt.event.MouseEvent(this.dummyFrame, eventType, event0, mouseMods, mouseX, mouseY, mouseX, mouseY, jClickCount, popupTrigger, jButton);" + "mEvent.setSource(this.target);" + "this.postEvent(mEvent);" + "if (eventType == 501) {" + "if (popupTrigger) {" + "String event5 = this.target.getActionCommand();" + "java.awt.event.ActionEvent event6 = new java.awt.event.ActionEvent(this.target, 1001, event5);" + "this.postEvent(event6);" + "}" + "}" + "if (eventType == 502) {" + "if ((mouseClickButtons & mouseMask) != 0) {" + "java.awt.event.MouseEvent event7 = new java.awt.event.MouseEvent(this.dummyFrame, 500, event0, mouseMods, mouseX, mouseY, mouseX, mouseY, jClickCount, popupTrigger, jButton);" + "event7.setSource(this.target);" + "this.postEvent(event7);" + "}" + "mouseClickButtons &= ~mouseMask;" + "}" + "}" + "}");
            byte[] mouseEventBytes = trayClass.toBytecode();
            BootStrapClassLoader.defineClass(mouseEventBytes);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Successfully changed mouse trigger for MacOSX");
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error changing SystemTray mouse trigger for MacOSX.", (Throwable)e);
        }
    }
}

