/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.IO;
import dorkbox.util.OS;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = OS.isWindows() ? (char)47 : (char)92;
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static byte[] ZIP_HEADER = new byte[]{80, 75, 3, 4};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameTo(File source, File dest) {
        boolean bl;
        if (source.renameTo(dest)) {
            return true;
        }
        if (dest.exists()) {
            File temp = new File(dest.getPath() + "_old");
            if (temp.exists() && !temp.delete()) {
                logger.warn("Failed to delete old intermediate file {}.", (Object)temp);
            }
            if (dest.renameTo(temp) && source.renameTo(dest)) {
                if (temp.delete()) {
                    logger.warn("Failed to delete intermediate file {}.", (Object)temp);
                }
                return true;
            }
        }
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(source);
            fout = new FileOutputStream(dest);
            IO.copyStream(fin, fout);
            IO.close(fin);
            if (!source.delete()) {
                logger.warn("Failed to delete {} after brute force copy to {}.", (Object)source, (Object)dest);
            }
            bl = true;
        }
        catch (IOException ioe) {
            boolean bl2;
            try {
                logger.warn("Failed to copy {} to {}.", new Object[]{source, dest, ioe});
                bl2 = false;
            }
            catch (Throwable throwable) {
                IO.close(fin);
                IO.close(fout);
                throw throwable;
            }
            IO.close(fin);
            IO.close(fout);
            return bl2;
        }
        IO.close(fin);
        IO.close(fout);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(Reader in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            BufferedReader bin = new BufferedReader(in);
            while ((line = bin.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            IO.close(in);
        }
        return lines;
    }

    public static File copyFile(String in, String out) throws IOException {
        return FileUtil.copyFile(new File(in), new File(out));
    }

    public static File copyFileToDir(String in, String out) throws IOException {
        return FileUtil.copyFileToDir(new File(in), new File(out));
    }

    public static File copyFileToDir(File in, File out) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("in cannot be null.");
        }
        if (out == null) {
            throw new IllegalArgumentException("out cannot be null.");
        }
        if (!out.isDirectory()) {
            throw new IOException("Out file is not a directory! '" + out.getAbsolutePath() + "'");
        }
        return FileUtil.copyFile(in, new File(out, in.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFile(File in, File out) throws IOException {
        Logger logger2;
        String normalizedout;
        if (in == null) {
            throw new IllegalArgumentException("in cannot be null.");
        }
        if (out == null) {
            throw new IllegalArgumentException("out cannot be null.");
        }
        String normalizedIn = FileUtil.normalize(in.getAbsolutePath());
        if (normalizedIn.equalsIgnoreCase(normalizedout = FileUtil.normalize(out.getAbsolutePath()))) {
            logger.warn("Source equals destination! " + normalizedIn);
            return out;
        }
        File parentOut = out.getParentFile();
        if (!parentOut.canWrite()) {
            parentOut.mkdirs();
        }
        if ((logger2 = logger).isTraceEnabled()) {
            logger2.trace("Copying file: {}  -->  {}", (Object)in, (Object)out);
        }
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel destinationChannel = null;
        try {
            sourceChannel = new FileInputStream(normalizedIn).getChannel();
            destinationChannel = new FileOutputStream(normalizedout).getChannel();
            if (sourceChannel.size() == 0L) {
                logger2.warn("Source size is ZERO: " + normalizedIn);
            }
            sourceChannel.transferTo(0L, sourceChannel.size(), (WritableByteChannel)((Object)destinationChannel));
        }
        finally {
            try {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (destinationChannel != null) {
                    destinationChannel.close();
                }
            }
            catch (Exception exception) {}
        }
        out.setLastModified(in.lastModified());
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File concatFiles(File one, File two) {
        if (one == null) {
            throw new IllegalArgumentException("one cannot be null.");
        }
        if (two == null) {
            throw new IllegalArgumentException("two cannot be null.");
        }
        String normalizedOne = FileUtil.normalize(one.getAbsolutePath());
        String normalizedTwo = FileUtil.normalize(two.getAbsolutePath());
        Logger logger2 = logger;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Cocating file: {}  -->  {}", (Object)one, (Object)two);
        }
        FileChannel channelOne = null;
        AbstractInterruptibleChannel channelTwo = null;
        try {
            channelOne = new FileOutputStream(normalizedOne, true).getChannel();
            channelTwo = new FileInputStream(normalizedTwo).getChannel();
            for (long size = two.length(); size > 0L; size -= channelOne.transferFrom((ReadableByteChannel)((Object)channelTwo), 0L, size)) {
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        finally {
            try {
                if (channelOne != null) {
                    channelOne.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (channelTwo != null) {
                    channelTwo.close();
                }
            }
            catch (Exception exception) {}
        }
        one.setLastModified(System.currentTimeMillis());
        return one;
    }

    public static File moveFile(String in, String out) throws IOException {
        if (in == null || in.isEmpty()) {
            throw new IllegalArgumentException("in cannot be null.");
        }
        if (out == null || out.isEmpty()) {
            throw new IllegalArgumentException("out cannot be null.");
        }
        return FileUtil.moveFile(new File(in), new File(out));
    }

    public static File moveFile(File in, File out) throws IOException {
        boolean renameSuccess;
        if (in == null) {
            throw new IllegalArgumentException("in cannot be null.");
        }
        if (out == null) {
            throw new IllegalArgumentException("out cannot be null.");
        }
        if (out.canRead()) {
            out.delete();
        }
        if (!(renameSuccess = FileUtil.renameTo(in, out))) {
            throw new IOException("Unable to move file: '" + in.getAbsolutePath() + "' -> '" + out.getAbsolutePath() + "'");
        }
        return out;
    }

    public static void copyDirectory(String src, String dest, String ... namesToIgnore) throws IOException {
        FileUtil.copyDirectory(new File(src), new File(dest), namesToIgnore);
    }

    public static void copyDirectory(File src_, File dest_, String ... namesToIgnore) throws IOException {
        File src = FileUtil.normalize(src_);
        File dest = FileUtil.normalize(dest_);
        if (namesToIgnore.length > 0) {
            String name = src.getName();
            for (String ignore : namesToIgnore) {
                if (!name.equals(ignore)) continue;
                return;
            }
        }
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
                Logger logger2 = logger;
                if (logger2.isTraceEnabled()) {
                    logger2.trace("Directory copied from  {}  -->  {}", (Object)src, (Object)dest);
                }
            }
            if ((files = src.list()) != null) {
                for (String file : files) {
                    File srcFile = new File(src, file);
                    File destFile = new File(dest, file);
                    FileUtil.copyDirectory(srcFile, destFile, namesToIgnore);
                }
            }
        } else {
            FileUtil.copyFile(src, dest);
        }
    }

    public static void moveDirectory(String src, String dest, String ... fileNamesToIgnore) throws IOException {
        FileUtil.moveDirectory(new File(src), new File(dest), fileNamesToIgnore);
    }

    public static void moveDirectory(File src, File dest, String ... fileNamesToIgnore) throws IOException {
        if (fileNamesToIgnore.length > 0) {
            String name = src.getName();
            for (String ignore : fileNamesToIgnore) {
                if (!name.equals(ignore)) continue;
                return;
            }
        }
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
                Logger logger2 = logger;
                if (logger2.isTraceEnabled()) {
                    logger2.trace("Directory copied from  {}  -->  {}", (Object)src, (Object)dest);
                }
            }
            if ((files = src.list()) != null) {
                for (String file : files) {
                    File srcFile = new File(src, file);
                    File destFile = new File(dest, file);
                    FileUtil.moveDirectory(srcFile, destFile, fileNamesToIgnore);
                }
            }
        } else {
            FileUtil.moveFile(src, dest);
        }
    }

    public static boolean delete(String fileName, String ... fileNamesToIgnore) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cannot be null.");
        }
        return FileUtil.delete(new File(fileName), fileNamesToIgnore);
    }

    public static boolean delete(File file, String ... namesToIgnore) {
        File[] files;
        if (!file.exists()) {
            return true;
        }
        boolean thingsDeleted = false;
        boolean ignored = false;
        Logger logger2 = logger;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                boolean delete = true;
                File file2 = files[i];
                String name2 = file2.getName();
                String name2Full = FileUtil.normalize(file2.getAbsolutePath());
                if (file2.isDirectory()) {
                    for (String name : namesToIgnore) {
                        if (name.charAt(0) == '/' && name.equals(name2)) {
                            if (logger2.isTraceEnabled()) {
                                logger2.trace("Skipping delete dir: {}", (Object)file2);
                            }
                            ignored = true;
                            delete = false;
                            break;
                        }
                        if (!name.equals(name2Full)) continue;
                        if (logger2.isTraceEnabled()) {
                            logger2.trace("Skipping delete dir: {}", (Object)file2);
                        }
                        ignored = true;
                        delete = false;
                        break;
                    }
                    if (!delete) continue;
                    if (logger2.isTraceEnabled()) {
                        logger2.trace("Deleting dir: {}", (Object)file2);
                    }
                    FileUtil.delete(file2, namesToIgnore);
                    continue;
                }
                for (String name : namesToIgnore) {
                    if (name.charAt(0) != '/' && name.equals(name2)) {
                        if (logger2.isTraceEnabled()) {
                            logger2.trace("Skipping delete file: {}", (Object)file2);
                        }
                        ignored = true;
                        delete = false;
                        break;
                    }
                    if (!name.equals(name2Full)) continue;
                    if (logger2.isTraceEnabled()) {
                        logger2.trace("Skipping delete file: {}", (Object)file2);
                    }
                    ignored = true;
                    delete = false;
                    break;
                }
                if (!delete) continue;
                if (logger2.isTraceEnabled()) {
                    logger2.trace("Deleting file: {}", (Object)file2);
                }
                thingsDeleted |= file2.delete();
            }
        }
        if (ignored) {
            if (logger2.isTraceEnabled()) {
                logger2.trace("Skipping deleting file: {}", (Object)file);
            }
            return false;
        }
        if (logger2.isTraceEnabled()) {
            logger2.trace("Deleting file: {}", (Object)file);
        }
        return thingsDeleted |= file.delete();
    }

    public static String mkdir(File location) {
        Logger logger2;
        if (location == null) {
            throw new IllegalArgumentException("fileDir cannot be null.");
        }
        String path = FileUtil.normalize(location).getAbsolutePath();
        if (location.mkdirs() && (logger2 = logger).isTraceEnabled()) {
            logger2.trace("Created directory: {}", (Object)path);
        }
        return path;
    }

    public static String mkdir(String location) {
        if (location == null) {
            throw new IllegalArgumentException("path cannot be null.");
        }
        return FileUtil.mkdir(new File(location));
    }

    public static File tempFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cannot be null");
        }
        return FileUtil.normalize(File.createTempFile(fileName, null)).getAbsoluteFile();
    }

    public static String tempDirectory(String directoryName) throws IOException {
        if (directoryName == null) {
            throw new IllegalArgumentException("directoryName cannot be null");
        }
        File file = File.createTempFile(directoryName, null);
        if (!file.delete()) {
            throw new IOException("Unable to delete temp file: " + file);
        }
        if (!file.mkdir()) {
            throw new IOException("Unable to create temp directory: " + file);
        }
        return FileUtil.normalize(file).getAbsolutePath();
    }

    public static boolean isZipStream(InputStream in) {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        boolean isZip = true;
        try {
            in.mark(ZIP_HEADER.length);
            for (int i = 0; i < ZIP_HEADER.length; ++i) {
                if (ZIP_HEADER[i] == (byte)in.read()) continue;
                isZip = false;
                break;
            }
            in.reset();
        }
        catch (Exception e) {
            isZip = false;
        }
        return isZip;
    }

    public static boolean isZipFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cannot be null");
        }
        return FileUtil.isZipFile(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipFile(File file) {
        boolean isZip = true;
        byte[] buffer = new byte[ZIP_HEADER.length];
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            raf.readFully(buffer);
            for (int i = 0; i < ZIP_HEADER.length; ++i) {
                if (buffer[i] == ZIP_HEADER[i]) continue;
                isZip = false;
                break;
            }
        }
        catch (Exception e) {
            isZip = false;
            if (e instanceof FileNotFoundException) {
                e.printStackTrace();
            }
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return isZip;
    }

    public static void unzip(String zipFile, String outputDir) throws IOException {
        FileUtil.unzipJar(zipFile, outputDir, true);
    }

    public static void unzip(File zipFile, File outputDir) throws IOException {
        FileUtil.unzipJar(zipFile, outputDir, true);
    }

    public static void unzip(ZipInputStream inputStream, String outputDir) throws IOException {
        if (outputDir == null) {
            throw new IllegalArgumentException("outputDir cannot be null.");
        }
        FileUtil.unzip(inputStream, new File(outputDir));
    }

    public static void unzip(ZipInputStream inputStream, File outputDir) throws IOException {
        FileUtil.unzipJar(inputStream, outputDir, true);
    }

    public static void unzipJar(String zipFile, String outputDir, boolean extractManifest) throws IOException {
        if (zipFile == null) {
            throw new IllegalArgumentException("zipFile cannot be null.");
        }
        if (outputDir == null) {
            throw new IllegalArgumentException("outputDir cannot be null.");
        }
        FileUtil.unjarzip0(new File(zipFile), new File(outputDir), extractManifest);
    }

    public static void unzipJar(File zipFile, File outputDir, boolean extractManifest) throws IOException {
        if (zipFile == null) {
            throw new IllegalArgumentException("zipFile cannot be null.");
        }
        if (outputDir == null) {
            throw new IllegalArgumentException("outputDir cannot be null.");
        }
        FileUtil.unjarzip0(zipFile, outputDir, extractManifest);
    }

    public static void unzipJar(ZipInputStream inputStream, File outputDir, boolean extractManifest) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        if (outputDir == null) {
            throw new IllegalArgumentException("outputDir cannot be null.");
        }
        FileUtil.unjarzip1(inputStream, outputDir, extractManifest);
    }

    private static void unjarzip0(File zipFile, File outputDir, boolean extractManifest) throws IOException {
        if (zipFile == null) {
            throw new IllegalArgumentException("zipFile cannot be null.");
        }
        if (outputDir == null) {
            throw new IllegalArgumentException("outputDir cannot be null.");
        }
        long fileLength = zipFile.length();
        if (fileLength > 0x7FFFFFFEL) {
            throw new RuntimeException("Source filesize is too large!");
        }
        ZipInputStream inputStream = new ZipInputStream(new FileInputStream(zipFile));
        FileUtil.unjarzip1(inputStream, outputDir, extractManifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unjarzip1(ZipInputStream inputStream, File outputDir, boolean extractManifest) throws IOException {
        try {
            ZipEntry entry;
            while ((entry = inputStream.getNextEntry()) != null) {
                String name = entry.getName();
                if (!extractManifest && name.startsWith("META-INF/")) continue;
                File file = new File(outputDir, name);
                if (entry.isDirectory()) {
                    FileUtil.mkdir(file.getPath());
                    continue;
                }
                FileUtil.mkdir(file.getParent());
                FileOutputStream output = new FileOutputStream(file);
                try {
                    IO.copyStream(inputStream, output);
                }
                finally {
                    IO.close(output);
                }
            }
        }
        finally {
            IO.close(inputStream);
        }
    }

    public static List<File> parseDir(String rootDirectory) throws IOException {
        if (rootDirectory == null) {
            throw new IllegalArgumentException("rootDirectory cannot be null");
        }
        return FileUtil.parseDir(new File(rootDirectory), new String[]{null});
    }

    public static List<File> parseDir(File rootDirectory) throws IOException {
        return FileUtil.parseDir(rootDirectory, new String[]{null});
    }

    public static List<File> parseDir(File rootDirectory, String ... extensionsToMatch) throws IOException {
        LinkedList<File> jarList = new LinkedList<File>();
        LinkedList<File> directories = new LinkedList<File>();
        if (!(rootDirectory = FileUtil.normalize(rootDirectory.getAbsoluteFile())).exists()) {
            throw new IOException("Location does not exist: " + rootDirectory.getAbsolutePath());
        }
        if (rootDirectory.isDirectory()) {
            directories.add(rootDirectory);
            while (directories.peek() != null) {
                File dir = (File)directories.poll();
                File[] listFiles = dir.listFiles();
                if (listFiles == null) continue;
                for (File file : listFiles) {
                    if (file.isDirectory()) {
                        directories.add(file);
                        continue;
                    }
                    if (extensionsToMatch == null || extensionsToMatch.length == 0 || extensionsToMatch[0] == null) {
                        jarList.add(file);
                        continue;
                    }
                    for (String e : extensionsToMatch) {
                        if (!file.getAbsolutePath().endsWith(e)) continue;
                        jarList.add(file);
                    }
                }
            }
        } else {
            throw new IOException("Cannot search directory children if the dir is a file name: " + rootDirectory.getAbsolutePath());
        }
        return jarList;
    }

    public static String getChildRelativeToDir(String fileName, String dirInHeirarchy) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName cannot be null.");
        }
        return FileUtil.getChildRelativeToDir(new File(fileName), dirInHeirarchy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getChildRelativeToDir(File file, String dirInHeirarchy) {
        File parent;
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        if (dirInHeirarchy == null || dirInHeirarchy.isEmpty()) {
            throw new IllegalArgumentException("dirInHeirarchy cannot be null.");
        }
        String[] split = dirInHeirarchy.split(File.separator);
        int splitIndex = split.length - 1;
        String absolutePath = file.getAbsolutePath();
        if (splitIndex == 0) {
            for (parent = file; parent != null; parent = parent.getParentFile()) {
                String parentName = parent.getName();
                if (!parentName.equals(dirInHeirarchy)) continue;
                parentName = parent.getAbsolutePath();
                return absolutePath.substring(parentName.length() + 1);
            }
            return null;
        } else {
            boolean matched = false;
            while (parent != null) {
                String parentName = parent.getName();
                if (matched) {
                    if (!parentName.equals(split[splitIndex])) return null;
                    if (--splitIndex < 0) {
                        if (absolutePath.length() != dirInHeirarchy.length()) return absolutePath.substring(dirInHeirarchy.length() + 1, absolutePath.length());
                        return null;
                    }
                } else if (parentName.equals(split[splitIndex])) {
                    matched = true;
                    --splitIndex;
                }
                parent = parent.getParentFile();
            }
        }
        return null;
    }

    public static String getParentRelativeToDir(String fileName, String dirInHeirarchy) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName cannot be null.");
        }
        return FileUtil.getParentRelativeToDir(new File(fileName), dirInHeirarchy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getParentRelativeToDir(File file, String dirInHeirarchy) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        if (dirInHeirarchy == null) throw new IllegalArgumentException("dirInHeirarchy cannot be null.");
        if (dirInHeirarchy.isEmpty()) {
            throw new IllegalArgumentException("dirInHeirarchy cannot be null.");
        }
        String[] split = dirInHeirarchy.split(File.separator);
        int splitIndex = split.length - 1;
        File parent = file;
        if (splitIndex == 0) {
            while (parent != null) {
                String parentName = parent.getName();
                if (parentName.equals(dirInHeirarchy)) {
                    parent = parent.getParentFile();
                    return parent.getAbsolutePath();
                }
                parent = parent.getParentFile();
            }
            return null;
        }
        boolean matched = false;
        while (parent != null) {
            String parentName = parent.getName();
            if (matched) {
                if (!parentName.equals(split[splitIndex])) return null;
                if (--splitIndex < 0) {
                    parent = parent.getParentFile();
                    return parent.getAbsolutePath();
                }
            } else if (parentName.equals(split[splitIndex])) {
                matched = true;
                --splitIndex;
            }
            parent = parent.getParentFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractFromZip(String zipFile, String fileToExtract) throws IOException {
        if (zipFile == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        if (fileToExtract == null) {
            throw new IllegalArgumentException("fileToExtract cannot be null.");
        }
        try (ZipInputStream inputStrem = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = inputStrem.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory()) continue;
                if (!name.equals(fileToExtract)) continue;
                File tempFile = FileUtil.tempFile(name);
                tempFile.deleteOnExit();
                try (FileOutputStream output = new FileOutputStream(tempFile);){
                    IO.copyStream(inputStrem, output);
                }
                String string = tempFile.getAbsolutePath();
                return string;
            }
        }
        return null;
    }

    public static String normalize(String filename) {
        return FileUtil.doNormalize(filename, SYSTEM_SEPARATOR, true);
    }

    public static String normalizeAsFile(String filename) {
        return FileUtil.doNormalize(new File(filename).getAbsolutePath(), SYSTEM_SEPARATOR, true);
    }

    public static File normalize(File file) {
        if (file == null) {
            return null;
        }
        String asString = FileUtil.doNormalize(file.getAbsolutePath(), SYSTEM_SEPARATOR, true);
        if (asString == null) {
            return null;
        }
        return new File(asString).getAbsoluteFile();
    }

    public static String normalize(String filename, boolean unixSeparator) {
        char separator = unixSeparator ? (char)'/' : '\\';
        return FileUtil.doNormalize(filename, separator, true);
    }

    public static String normalizeNoEndSeparator(String filename) {
        return FileUtil.doNormalize(filename, SYSTEM_SEPARATOR, false);
    }

    public static String normalizeNoEndSeparator(String filename, boolean unixSeparator) {
        char separator = unixSeparator ? (char)'/' : '\\';
        return FileUtil.doNormalize(filename, separator, false);
    }

    private static String doNormalize(String filename, char separator, boolean keepSeparator) {
        int i;
        if (filename == null) {
            return null;
        }
        int size = filename.length();
        if (size == 0) {
            return filename;
        }
        int prefix = FileUtil.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        char[] array = new char[size + 2];
        filename.getChars(0, filename.length(), array, 0);
        char otherSeparator = separator == SYSTEM_SEPARATOR ? OTHER_SEPARATOR : SYSTEM_SEPARATOR;
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != otherSeparator) continue;
            array[i2] = separator;
        }
        boolean lastIsDirectory = true;
        if (array[size - 1] != separator) {
            array[size++] = separator;
            lastIsDirectory = false;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != separator) continue;
            System.arraycopy(array, i, array, i - 1, size - i);
            --size;
            --i;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != '.' || i != prefix + 1 && array[i - 2] != separator) continue;
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            System.arraycopy(array, i + 1, array, i - 1, size - i);
            size -= 2;
            --i;
        }
        block3: for (i = prefix + 2; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != '.' || array[i - 2] != '.' || i != prefix + 2 && array[i - 3] != separator) continue;
            if (i == prefix + 2) {
                return null;
            }
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            for (int j = i - 4; j >= prefix; --j) {
                if (array[j] != separator) continue;
                System.arraycopy(array, i + 1, array, j + 1, size - i);
                size -= i - j;
                i = j + 1;
                continue block3;
            }
            System.arraycopy(array, i + 1, array, prefix, size - i);
            size -= i + 1 - prefix;
            i = prefix + 1;
        }
        if (size <= 0) {
            return "";
        }
        if (size <= prefix) {
            return new String(array, 0, size);
        }
        if (lastIsDirectory && keepSeparator) {
            return new String(array, 0, size);
        }
        return new String(array, 0, size - 1);
    }

    public static int getPrefixLength(String filename) {
        if (filename == null) {
            return -1;
        }
        int len = filename.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = filename.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return FileUtil.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = filename.indexOf(47, 1);
            int posWin = filename.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = filename.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 || !FileUtil.isSeparator(filename.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (FileUtil.isSeparator(ch0) && FileUtil.isSeparator(ch1)) {
            int posUnix = filename.indexOf(47, 2);
            int posWin = filename.indexOf(92, 2);
            if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
                return -1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        return FileUtil.isSeparator(ch0) ? 1 : 0;
    }

    private static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        int dot = fileName.lastIndexOf(46);
        if (dot > -1) {
            return fileName.substring(dot + 1);
        }
        return "";
    }

    public static String getNameWithoutExtension(String fileName) {
        int dot = fileName.lastIndexOf(46);
        if (dot > -1) {
            return fileName.substring(0, dot);
        }
        return fileName;
    }
}

