/**
 * © Nowina Solutions, 2015-2015
 *
 * Concédée sous licence EUPL, version 1.1 ou – dès leur approbation par la Commission européenne - versions ultérieures de l’EUPL (la «Licence»).
 * Vous ne pouvez utiliser la présente œuvre que conformément à la Licence.
 * Vous pouvez obtenir une copie de la Licence à l’adresse suivante:
 *
 * http://ec.europa.eu/idabc/eupl5
 *
 * Sauf obligation légale ou contractuelle écrite, le logiciel distribué sous la Licence est distribué «en l’état»,
 * SANS GARANTIES OU CONDITIONS QUELLES QU’ELLES SOIENT, expresses ou implicites.
 * Consultez la Licence pour les autorisations et les restrictions linguistiques spécifiques relevant de la Licence.
 */
package lu.nowina.nexu.api;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "scAPI")
@XmlEnum
public enum ScAPI {

	@XmlEnumValue("MSCAPI") MSCAPI("MSCAPI"),

	@XmlEnumValue("PKCS11") PKCS_11("PKCS11"),

	@XmlEnumValue("MOCCA") MOCCA("MOCCA"),
	
	@XmlEnumValue("HSM PKCS11") HSM_PKCS_11("HSM PKCS11");

	private final String value;

	ScAPI(String v) {
		value = v;
	}

	public String value() {
		return value;
	}

	public static ScAPI fromValue(String v) {
		for (ScAPI c : ScAPI.values()) {
			if (c.value.equals(v)) {
				return c;
			}
		}
		throw new IllegalArgumentException(v);
	}

}
