package ge.id.plugin;

import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;

import java.security.cert.X509Certificate;
import java.util.List;

public class EidPrivateKeyEntry implements DSSPrivateKeyEntry {

    private CertificateToken certificate;

    private CertificateToken[] certificateChain;

    public EidPrivateKeyEntry(CertificateToken certificate, List<X509Certificate> signatureChain) {
        this.certificate = certificate;
        certificateChain = new CertificateToken[signatureChain.size()];
        for (int i = 0; i < signatureChain.size(); i++) {
            certificateChain[i] = new CertificateToken(signatureChain.get(i));
        }
    }

    @Override
    public CertificateToken getCertificate() {
        return certificate;
    }

    @Override
    public CertificateToken[] getCertificateChain() {
        return certificateChain;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return EncryptionAlgorithm.RSA;
    }
}
