package ge.id.plugin;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import lu.nowina.nexu.api.*;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class GeorgianStampCardProductAdapter extends AbstractCardProductAdapter {

    @Override
    protected boolean accept(DetectedCard card) {
        return card.getAtr().equalsIgnoreCase("3BDD96008131FE4580F9A00000007701080007900070");
    }

    @Override
    protected String getLabel(NexuAPI api, DetectedCard card, PasswordInputCallback callback) {
        throw new IllegalStateException("Non-invokable method!");
    }

    @Override
    protected String getLabel(NexuAPI api, DetectedCard card, PasswordInputCallback callback,
                              MessageDisplayCallback messageCallback) {
        return ResourceBundle.getBundle("bundles/georgianstampcard").getString("product.selection.georgian.stampcard");
    }

    @Override
    protected boolean supportMessageDisplayCallback(DetectedCard card) {
        return true;
    }

    @Override
    protected SignatureTokenConnection connect(NexuAPI api, DetectedCard card, PasswordInputCallback passwordCallback) {
        throw new IllegalStateException("Non-invokable method!");
    }

    @Override
    protected SignatureTokenConnection connect(NexuAPI api, DetectedCard card, PasswordInputCallback passwordCallback, MessageDisplayCallback messageCallback) {
        return new GeorgianStampCardSignatureTokenConnection(api, card, passwordCallback, messageCallback);
    }

    @Override
    protected boolean canReturnIdentityInfo(DetectedCard card) {
        return false;
    }

    @Override
    public GetIdentityInfoResponse getIdentityInfo(SignatureTokenConnection token) {
        throw new IllegalStateException("Non-invokable method!");
    }

    @Override
    protected boolean supportCertificateFilter(DetectedCard card) {
        return false;
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys(SignatureTokenConnection token, CertificateFilter certificateFilter) {
        return token.getKeys();
    }

    @Override
    protected boolean canReturnSuportedDigestAlgorithms(DetectedCard card) {
        return true;
    }

    @Override
    protected List<DigestAlgorithm> getSupportedDigestAlgorithms(DetectedCard card) {
        return Arrays.asList(DigestAlgorithm.SHA256);
    }

    @Override
    protected DigestAlgorithm getPreferredDigestAlgorithm(DetectedCard card) {
        return DigestAlgorithm.SHA256;
    }
}
