/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.util.SwingUtil;
import java.awt.event.ActionListener;

public class Checkbox
extends Entry {
    private volatile boolean isChecked = false;
    private volatile String text;
    private volatile ActionListener callback;
    private volatile boolean enabled = true;
    private volatile char mnemonicKey;

    public Checkbox() {
        this(null, null);
    }

    public Checkbox(String text, ActionListener callback) {
        this.text = text;
        this.callback = callback;
    }

    public Checkbox(String text) {
        this(text, null);
    }

    public void bind(CheckboxPeer peer, Menu parent, SystemTray systemTray) {
        super.bind(peer, parent, systemTray);
        peer.setEnabled(this);
        peer.setText(this);
        peer.setCallback(this);
        peer.setShortcut(this);
        peer.setChecked(this);
    }

    public boolean getChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setChecked(this);
        }
    }

    public ActionListener getCallback() {
        return this.callback;
    }

    public void setCallback(ActionListener callback) {
        this.callback = callback;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setCallback(this);
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setEnabled(this);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setText(this);
        }
    }

    public char getShortcut() {
        return this.mnemonicKey;
    }

    public void setShortcut(char key) {
        this.mnemonicKey = key;
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setShortcut(this);
        }
    }

    public void setShortcut(int key) {
        this.mnemonicKey = SwingUtil.getFromVirtualKey(key);
        if (this.peer != null) {
            ((CheckboxPeer)this.peer).setShortcut(this);
        }
    }
}

