/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.nativeUI;

import com.sun.jna.Pointer;
import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.jna.linux.GCallback;
import dorkbox.systemTray.jna.linux.Gobject;
import dorkbox.systemTray.jna.linux.Gtk;
import dorkbox.systemTray.nativeUI.GtkBaseMenuItem;
import dorkbox.systemTray.nativeUI.GtkMenu;
import dorkbox.systemTray.peer.CheckboxPeer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class GtkMenuItemCheckbox
extends GtkBaseMenuItem
implements CheckboxPeer,
GCallback {
    private final GtkMenu parent;
    private volatile ActionListener callback;
    private volatile boolean isChecked = false;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';

    GtkMenuItemCheckbox(GtkMenu parent) {
        super(Gtk.gtk_check_menu_item_new_with_mnemonic(""));
        this.parent = parent;
        Gobject.g_signal_connect_object(this._native, "activate", this, null, 0);
    }

    @Override
    public int callback(Pointer instance, Pointer data) {
        if (this.callback != null) {
            Gtk.proxyClick(null, this.callback);
        }
        return 1;
    }

    @Override
    public boolean hasImage() {
        return true;
    }

    @Override
    public void setSpacerImage(boolean everyoneElseHasImages) {
    }

    @Override
    public void setEnabled(final Checkbox menuItem) {
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.gtk_widget_set_sensitive(GtkMenuItemCheckbox.this._native, menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(Checkbox menuItem) {
        String text;
        int i;
        final String textWithMnemonic = this.mnemonicKey != '\u0000' ? ((i = (text = menuItem.getText()).toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? text.substring(0, i) + "_" + text.substring(i) : menuItem.getText()) : menuItem.getText();
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.gtk_menu_item_set_label(GtkMenuItemCheckbox.this._native, textWithMnemonic);
                Gtk.gtk_widget_show_all(GtkMenuItemCheckbox.this._native);
            }
        });
    }

    @Override
    public void setCallback(final Checkbox menuItem) {
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    menuItem.setChecked(!GtkMenuItemCheckbox.this.isChecked);
                    ActionListener cb = menuItem.getCallback();
                    if (cb != null) {
                        try {
                            cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    }
                }
            };
        }
    }

    @Override
    public void setChecked(Checkbox checkbox) {
        this.isChecked = checkbox.getChecked();
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.gtk_check_menu_item_set_active(GtkMenuItemCheckbox.this._native, GtkMenuItemCheckbox.this.isChecked);
            }
        });
    }

    @Override
    public void setShortcut(Checkbox checkbox) {
        this.mnemonicKey = Character.toLowerCase(checkbox.getShortcut());
        this.setText(checkbox);
    }

    @Override
    public void remove() {
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.gtk_container_remove(((GtkMenuItemCheckbox)GtkMenuItemCheckbox.this).parent._nativeMenu, GtkMenuItemCheckbox.this._native);
                GtkMenuItemCheckbox.super.remove();
                if (GtkMenuItemCheckbox.this.image != null) {
                    Gtk.gtk_container_remove(GtkMenuItemCheckbox.this._native, GtkMenuItemCheckbox.this.image);
                    GtkMenuItemCheckbox.this.image = null;
                }
                GtkMenuItemCheckbox.this.parent.remove(GtkMenuItemCheckbox.this);
            }
        });
    }
}

