/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.util.OS;
import java.lang.reflect.Method;

public class JavaFX {
    private static final Method dispatchMethod;
    private static final Method isEventThreadMethod;
    private static final Object isEventThreadObject;

    public static void init() {
        if (dispatchMethod == null || isEventThreadMethod == null) {
            SystemTray.logger.error("Unable to initialize JavaFX! Please create an issue with your OS and Java version so we may further investigate this issue.");
        }
    }

    public static void dispatch(Runnable runnable) {
        try {
            dispatchMethod.invoke(null, runnable);
        }
        catch (Throwable e) {
            SystemTray.logger.error("Unable to execute JavaFX runLater(). Please create an issue with your OS and Java version so we may further investigate this issue.");
        }
    }

    public static boolean isEventThread() {
        try {
            if (OS.javaVersion <= 7) {
                return (Boolean)isEventThreadMethod.invoke(null, new Object[0]);
            }
            return (Boolean)isEventThreadMethod.invoke(isEventThreadObject, null);
        }
        catch (Throwable e) {
            SystemTray.logger.error("Unable to check if JavaFX is in the event thread. Please create an issue with your OS and Java version so we may further investigate this issue.");
            return false;
        }
    }

    public static void onShutdown(Runnable runnable) {
        try {
            Class<?> clazz = Class.forName("com.sun.javafx.tk.Toolkit");
            Method method = clazz.getMethod("getToolkit", new Class[0]);
            Object o = method.invoke(null, new Object[0]);
            Method m = o.getClass().getMethod("addShutdownHook", Runnable.class);
            m.invoke(o, runnable);
        }
        catch (Throwable e) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.error("Cannot initialize JavaFX", e);
            }
            SystemTray.logger.error("Unable to insert shutdown hook into JavaFX. Please create an issue with your OS and Java version so we may further investigate this issue.");
        }
    }

    static {
        Method _isEventThreadMethod = null;
        Method _dispatchMethod = null;
        Object _isEventThreadObject = null;
        try {
            Class<?> clazz = Class.forName("javafx.application.Platform");
            _dispatchMethod = clazz.getMethod("runLater", Runnable.class);
            if (OS.javaVersion <= 7) {
                clazz = Class.forName("javafx.application.Platform");
                _isEventThreadMethod = clazz.getMethod("isFxApplicationThread", new Class[0]);
                _isEventThreadObject = null;
            } else {
                clazz = Class.forName("com.sun.javafx.tk.Toolkit");
                _isEventThreadMethod = clazz.getMethod("getToolkit", new Class[0]);
                _isEventThreadObject = _isEventThreadMethod.invoke(null, new Object[0]);
                _isEventThreadMethod = _isEventThreadObject.getClass().getMethod("isFxUserThread", null);
            }
        }
        catch (Throwable e) {
            SystemTray.logger.error("Cannot initialize JavaFX", e);
        }
        dispatchMethod = _dispatchMethod;
        isEventThreadMethod = _isEventThreadMethod;
        isEventThreadObject = _isEventThreadObject;
    }
}

