/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.process;

import dorkbox.util.OS;
import dorkbox.util.process.NullOutputStream;
import dorkbox.util.process.ProcessProxy;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ShellProcessBuilder {
    private final PrintStream outputStream;
    private final PrintStream outputErrorStream;
    private final InputStream inputStream;
    protected List<String> arguments = new ArrayList<String>();
    private String workingDirectory = null;
    private String executableName = null;
    private String executableDirectory = null;
    private Process process = null;
    private ProcessProxy writeToProcess_input = null;
    private ProcessProxy readFromProcess_output = null;
    private ProcessProxy readFromProcess_error = null;
    private boolean createReadWriterThreads = false;
    private boolean isShell;
    private String pipeToNullString = "";
    private List<String> fullCommand;

    public ShellProcessBuilder() {
        this(null, null, null);
    }

    public ShellProcessBuilder(PrintStream out) {
        this(null, out, out);
    }

    public ShellProcessBuilder(InputStream in, PrintStream out) {
        this(in, out, out);
    }

    public ShellProcessBuilder(InputStream in, PrintStream out, PrintStream err) {
        this.inputStream = in;
        this.outputStream = out;
        this.outputErrorStream = err;
    }

    public final ShellProcessBuilder createReadWriterThreads() {
        this.createReadWriterThreads = true;
        return this;
    }

    public final ShellProcessBuilder setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = new File(workingDirectory).getAbsolutePath();
        return this;
    }

    public final ShellProcessBuilder addArgument(String argument) {
        this.arguments.add(argument);
        return this;
    }

    public final ShellProcessBuilder addArguments(String ... paths) {
        for (String path : paths) {
            this.arguments.add(path);
        }
        return this;
    }

    public final ShellProcessBuilder addArguments(List<String> paths) {
        this.arguments.addAll(paths);
        return this;
    }

    public final ShellProcessBuilder setExecutable(String executableName) {
        this.executableName = executableName;
        return this;
    }

    public ShellProcessBuilder setExecutableDirectory(String executableDirectory) {
        this.executableDirectory = new File(executableDirectory).getAbsolutePath();
        return this;
    }

    public ShellProcessBuilder pipeOutputToNull() throws IllegalArgumentException {
        if (this.outputStream != null || this.outputErrorStream != null) {
            throw new IllegalArgumentException("Cannot pipe shell command to 'null' if an output stream is specified");
        }
        this.pipeToNullString = OS.isWindows() ? ">NUL" : ">/dev/null 2>&1";
        return this;
    }

    public String getCommand() {
        StringBuilder execCommand = new StringBuilder();
        Iterator<String> iterator = this.fullCommand.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            execCommand.append(s);
            if (!iterator.hasNext()) continue;
            execCommand.append(" ");
        }
        return execCommand.toString();
    }

    public int start() {
        boolean pipeToNull;
        block51: {
            this.fullCommand = new ArrayList<String>();
            if (this.executableName == null) {
                this.isShell = true;
                if (OS.isWindows()) {
                    this.executableName = "cmd";
                    this.fullCommand.add(this.executableName);
                    this.fullCommand.add("/c");
                } else {
                    this.executableName = "/bin/bash";
                    File file = new File(this.executableName);
                    if (!file.canExecute()) {
                        this.executableName = "/bin/sh";
                    }
                    this.fullCommand.add(this.executableName);
                    this.fullCommand.add("-c");
                }
            } else {
                if (this.workingDirectory != null && !this.workingDirectory.endsWith(File.separator)) {
                    this.workingDirectory = this.workingDirectory + File.separator;
                }
                if (this.executableDirectory != null) {
                    if (!this.executableDirectory.endsWith(File.separator)) {
                        this.executableDirectory = this.executableDirectory + File.separator;
                    }
                    this.fullCommand.add(0, this.executableDirectory + this.executableName);
                } else {
                    this.fullCommand.add(this.executableName);
                }
            }
            boolean bl = pipeToNull = !this.pipeToNullString.isEmpty();
            if (this.isShell && !OS.isWindows()) {
                StringBuilder stringBuilder = new StringBuilder(1024);
                for (String arg : this.arguments) {
                    stringBuilder.append(arg).append(" ");
                }
                if (!this.arguments.isEmpty()) {
                    if (pipeToNull) {
                        stringBuilder.append(this.pipeToNullString);
                    } else {
                        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                    }
                }
                this.fullCommand.add(stringBuilder.toString());
            } else {
                for (String arg : this.arguments) {
                    if (arg.contains(" ")) {
                        String[] split;
                        for (String s : split = arg.split(" ")) {
                            this.fullCommand.add(s);
                        }
                        continue;
                    }
                    this.fullCommand.add(arg);
                }
                if (pipeToNull) {
                    this.fullCommand.add(this.pipeToNullString);
                }
            }
            ProcessBuilder processBuilder = new ProcessBuilder(this.fullCommand);
            if (this.workingDirectory != null) {
                processBuilder.directory(new File(this.workingDirectory));
            }
            if (pipeToNull || this.outputErrorStream == null) {
                processBuilder.redirectErrorStream(true);
            }
            try {
                this.process = processBuilder.start();
            }
            catch (Exception ex) {
                if (this.outputErrorStream != null) {
                    this.outputErrorStream.println("There was a problem executing the program.  Details:");
                } else {
                    System.err.println("There was a problem executing the program.  Details:");
                }
                ex.printStackTrace(this.outputErrorStream);
                if (this.process == null) break block51;
                try {
                    this.process.destroy();
                    this.process = null;
                }
                catch (Exception e) {
                    if (this.outputErrorStream != null) {
                        this.outputErrorStream.println("Error destroying process:");
                    } else {
                        System.err.println("Error destroying process:");
                    }
                    e.printStackTrace(this.outputErrorStream);
                }
            }
        }
        if (this.process != null) {
            if (this.outputErrorStream == null && this.outputStream == null) {
                if (!pipeToNull) {
                    NullOutputStream nullOutputStream = new NullOutputStream();
                    this.readFromProcess_output = new ProcessProxy("Process Reader: " + this.executableName, this.process.getInputStream(), nullOutputStream);
                }
            } else {
                this.readFromProcess_output = new ProcessProxy("Process Reader: " + this.executableName, this.process.getInputStream(), this.outputStream);
                if (this.outputErrorStream != this.outputStream) {
                    this.readFromProcess_error = new ProcessProxy("Process Reader: " + this.executableName, this.process.getErrorStream(), this.outputErrorStream);
                }
            }
            if (this.inputStream != null) {
                this.writeToProcess_input = new ProcessProxy("Process Writer: " + this.executableName, this.inputStream, this.process.getOutputStream());
            }
            Thread hook = new Thread(new Runnable(){

                @Override
                public void run() {
                    ShellProcessBuilder.this.process.destroy();
                }
            });
            hook.setName("ShellProcess Shutdown Hook");
            try {
                Runtime.getRuntime().addShutdownHook(hook);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (this.writeToProcess_input != null) {
                if (this.createReadWriterThreads) {
                    this.writeToProcess_input.start();
                } else {
                    this.writeToProcess_input.run();
                }
            }
            if (this.createReadWriterThreads) {
                this.readFromProcess_output.start();
            } else {
                this.readFromProcess_output.run();
            }
            if (this.readFromProcess_error != null) {
                if (this.createReadWriterThreads) {
                    this.readFromProcess_error.start();
                } else {
                    this.readFromProcess_error.run();
                }
            }
            int exitValue = 0;
            try {
                this.process.waitFor();
                exitValue = this.process.exitValue();
                if (this.writeToProcess_input != null) {
                    this.writeToProcess_input.close();
                    this.writeToProcess_input.join();
                }
                this.readFromProcess_output.close();
                this.readFromProcess_output.join();
                if (this.readFromProcess_error != null) {
                    this.readFromProcess_error.close();
                    this.readFromProcess_error.join();
                }
                this.process.destroy();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                Runtime.getRuntime().removeShutdownHook(hook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return exitValue;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOutput(ByteArrayOutputStream byteArrayOutputStream) {
        String s;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        synchronized (byteArrayOutputStream2) {
            s = byteArrayOutputStream.toString();
            byteArrayOutputStream.reset();
        }
        int endIndex = s.lastIndexOf(OS.LINE_SEPARATOR);
        if (endIndex > -1) {
            return s.substring(0, endIndex);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutputLineBuffered(ByteArrayOutputStream byteArrayOutputStream) {
        String s;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        synchronized (byteArrayOutputStream2) {
            try {
                byteArrayOutputStream.wait();
            }
            catch (InterruptedException ignored) {
                return null;
            }
            s = byteArrayOutputStream.toString();
            byteArrayOutputStream.reset();
        }
        return s;
    }
}

