/**
 * © Nowina Solutions, 2015-2015
 *
 * Concédée sous licence EUPL, version 1.1 ou – dès leur approbation par la Commission européenne - versions ultérieures de l’EUPL (la «Licence»).
 * Vous ne pouvez utiliser la présente œuvre que conformément à la Licence.
 * Vous pouvez obtenir une copie de la Licence à l’adresse suivante:
 *
 * http://ec.europa.eu/idabc/eupl5
 *
 * Sauf obligation légale ou contractuelle écrite, le logiciel distribué sous la Licence est distribué «en l’état»,
 * SANS GARANTIES OU CONDITIONS QUELLES QU’ELLES SOIENT, expresses ou implicites.
 * Consultez la Licence pour les autorisations et les restrictions linguistiques spécifiques relevant de la Licence.
 */
package lu.nowina.nexu.api.flow;

/**
 * This enum defines some basic {@link OperationStatus}es.
 *
 * @author Jean Lepropre (jean.lepropre@nowina.lu)
 */
public enum BasicOperationStatus implements OperationStatus {
	SUCCESS("success", "The operation was completed successfully."),
	EXCEPTION("exception", "An exception was thrown during the operation."),
	USER_CANCEL("user.cancel", "The user has cancelled the operation.");
	
	private final String code;
	private final String label;
	
	private BasicOperationStatus(final String code, final String label) {
		this.code = code;
		this.label = label;
	}

	@Override
	public String getCode() {
		return code;
	}

	@Override
	public String getLabel() {
		return label;
	}
}
