package ge.id.plugin;

import javax.smartcardio.CommandAPDU;

public class PinPukHelper {

	public static CommandAPDU verifyPin(int pinRef, String pin, int pinMaxLength) {
		byte[] data = getPinBytes((byte) pinMaxLength, pin);
		return new CommandAPDU(0x00, 0x20, 0x00, pinRef, data);
	}

	public static CommandAPDU verifyPin(int pinRef, String pin) {
		return verifyPin(pinRef, pin, pin.length());
	}

    private static byte[] getPinBytes(byte maxLength, String pin) {
        if (maxLength < pin.length()) {
            throw new IllegalArgumentException("pin/puk length is more than maxLength");
        }
        if (!pin.matches("[0-9]+")) {
            throw new IllegalArgumentException("pin/puk must contain only numbers");
        }

        byte[] pinBytes = new byte[maxLength];
        byte[] actualPinBytes = pin.getBytes();

        System.arraycopy(actualPinBytes, 0, pinBytes, 0, actualPinBytes.length);

        for (int i = actualPinBytes.length; i < pinBytes.length; i++) {
            pinBytes[i] = (byte) 0xFF;
        }
        return pinBytes;
    }

}

